<?php

// Porto Container
add_action( 'vc_after_init', 'porto_load_container_shortcode' );

function porto_load_container_shortcode() {
	$animation_type     = porto_vc_animation_type();
	$animation_duration = porto_vc_animation_duration();
	$animation_delay    = porto_vc_animation_delay();
	$animation_reveal_clr = porto_vc_animation_reveal_clr();
	$custom_class       = porto_vc_custom_class();

	vc_map(
		array(
			'name'         => 'Porto ' . __( 'Container', 'porto-functionality' ),
			'base'         => 'porto_container',
			'category'     => __( 'Porto', 'porto-functionality' ),
			'description'  => __( 'Contain your sections and rows', 'porto-functionality' ),
			'icon'         => PORTO_WIDGET_URL . 'container.png',
			'class'        => 'porto-wpb-widget',
			'is_container' => true,
			'js_view'      => 'VcColumnView',
			'params'       => array(
				array(
					'type'        => 'textfield',
					'heading'     => __( 'ID of Sticky Content Marker', 'porto-functionality' ),
					'description' => esc_html__( 'Please add the ID of DOM for Sticky Content Marker like Shop 52. e.g: new-season', 'porto-functionality' ),
					'param_name'  => 'sticky_content_marker',
					'value'       => '',
					'hint'        => '<img src="' . PORTO_HINT_URL . 'st-content-cg.gif"/>',
				),
				array(
					'type'        => 'checkbox',
					'heading'     => __( 'Is half container?', 'porto-functionality' ),
					'param_name'  => 'is_half',
					'std'         => '',
					'admin_label' => true,
				),
				array(
					'type'        => 'checkbox',
					'heading'     => __( 'Is full width under 992px?', 'porto-functionality' ),
					'param_name'  => 'is_full_md',
					'description' => __( 'If unchecked, this container becomes full width under 768px.', 'porto-functionality' ),
					'std'         => '',
					'admin_label' => true,
					'dependency'  => array(
						'element'   => 'is_half',
						'not_empty' => true,
					),
				),
				array(
					'type'             => 'css_editor',
					'heading'          => __( 'CSS', 'porto-functionality' ),
					'param_name'       => 'css_design',
					'group'            => __( 'Design', 'porto-functionality' ),
					'edit_field_class' => 'vc_col-sm-12 vc_column no-vc-background no-vc-border creative_link_css_editor',
				),
				array(
					'type'        => 'el_id',
					'heading'     => esc_html__( 'Element ID', 'js_composer' ),
					'param_name'  => 'el_id',
					'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
				),
				$custom_class,
				$animation_type,
				$animation_duration,
				$animation_delay,
				$animation_reveal_clr,
			),
		)
	);

	if ( ! class_exists( 'WPBakeryShortCode_Porto_Container' ) ) {
		class WPBakeryShortCode_Porto_Container extends WPBakeryShortCodesContainer {
		}
	}
}
